package music;

public class Album {
    
    private String title;
    private String author;
    private int year;
    private Song[] songs;
    
    public Album(String title, String author, int year, Song[] songs) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.songs = songs;
    }
    
    public Album(String title, String author, int year, int noOfSongs) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.songs = new Song[noOfSongs];
        for (int i = 0; i < this.songs.length; i++) {
            songs[i] = new Song();
            songs[i].setAuthor(this.author);
            songs[i].setYear(this.year);
            songs[i].setTitle("Temporary title");
        }
    }
    
    public Album() {
    }

    public void initializeSongTitles(String[] titles) {
        for (int i = 0; i < this.songs.length; i++) {
            songs[i].setTitle(titles[i]);
        }
    }
    
    public void display() {
        System.out.println("Album " + this.title + ", by " + this.author);
        for (int i = 0; i < songs.length; i++) {
            songs[i].display();
        }
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    
    public void setSongs(Song[] songs) {
        this.songs = songs;
    }
    
    public Song[] getSongs() {
        return this.songs;
    }
    
    
}
